/*
 * Decompiled with CFR 0.152.
 */
package dev.zy.sensorboard.processor;

import dev.zy.sensorboard.data.Record;
import dev.zy.sensorboard.processor.Processor;
import dev.zy.sensorboard.processor.SerialMonitor;
import java.text.SimpleDateFormat;
import java.util.Date;

public class SerialProcessor
implements Processor {
    SerialMonitor com;

    public SerialProcessor(SerialMonitor com) {
        this.com = com;
    }

    @Override
    public void setWhite(int lv) {
        if (lv == 0) {
            try {
                this.com.sendData("SET WHITE OFF\n");
                Thread.sleep(100L);
                String string = this.com.getData();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return;
        }
        try {
            this.com.sendData("SET WHITE LEVEL " + lv + "\n");
            Thread.sleep(100L);
            String e = this.com.getData();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setUV(int lv) {
        if (lv == 0) {
            try {
                this.com.sendData("SET UV OFF\n");
                Thread.sleep(100L);
                String string = this.com.getData();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return;
        }
        try {
            this.com.sendData("SET UV LEVEL " + lv + "\n");
            Thread.sleep(100L);
            String e = this.com.getData();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setScal(int scaling) {
        try {
            this.com.sendData("SET SCAL " + scaling + "\n");
            Thread.sleep(100L);
            String string = this.com.getData();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public Record getRGB() {
        try {
            Record ret = new Record();
            this.com.sendData("GET RGB\n");
            Thread.sleep(100L);
            String info = this.com.getData().trim();
            if (info != null || !info.equals("")) {
                info = info.substring(1, info.length() - 1);
                String[] values = info.split(",");
                ret.setR(Integer.parseInt(values[0]));
                ret.setG(Integer.parseInt(values[1]));
                ret.setB(Integer.parseInt(values[2]));
                Date date = new Date();
                SimpleDateFormat formatter = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss.SSS");
                ret.setDatetime(formatter.format(date));
                return ret;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public boolean testConnect() {
        return this.getRGB() != null;
    }
}

